/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.validator;

import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.Problem;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ast.IParseError;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class HTMLParserValidator
extends AbstractBuildParticipant {
    public static final String ID = "com.aptana.editor.html.validator.HTMLParseErrorValidator";

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        HashMap<String, List> problems = new HashMap<String, List>();
        problems.put("com.aptana.contenttype.html", new ArrayList());
        problems.put("com.aptana.contenttype.js", new ArrayList());
        problems.put("com.aptana.contenttype.css", new ArrayList());
        String source = context.getContents();
        if (!StringUtil.isEmpty((String)source)) {
            try {
                context.getAST();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (!CollectionsUtil.isEmpty((Collection)context.getParseErrors())) {
                URI path = context.getURI();
                String sourcePath = path.toString();
                Document doc = new Document(source);
                for (IParseError parseError : context.getParseErrors()) {
                    int severity = parseError.getSeverity().intValue();
                    int line = -1;
                    try {
                        line = doc.getLineOfOffset(parseError.getOffset()) + 1;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    String language = parseError.getLangauge();
                    List langProblems = (List)problems.get(language);
                    langProblems.add(new Problem(severity, parseError.getMessage(), parseError.getOffset(), parseError.getLength(), line, sourcePath));
                    problems.put(language, langProblems);
                }
            }
        }
        context.putProblems("com.aptana.editor.html.problem", (Collection)problems.get("com.aptana.contenttype.html"));
        context.putProblems("com.aptana.js.core.problem", (Collection)problems.get("com.aptana.contenttype.js"));
        context.putProblems("com.aptana.editor.css.problem", (Collection)problems.get("com.aptana.contenttype.css"));
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.html.problem");
        context.removeProblems("com.aptana.js.core.problem");
        context.removeProblems("com.aptana.editor.css.problem");
    }
}

